% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_support.R
\name{get_support}
\alias{get_support}
\title{Computes support for skewed Lambert W x F distributions}
\usage{
get_support(tau, is.non.negative = FALSE, input.bounds = c(-Inf, Inf))
}
\arguments{
\item{tau}{named vector \eqn{\tau} which defines the variable transformation. Must have at least
\code{'mu_x'} and \code{'sigma_x'} element; see \code{\link{complete_tau}} for details.}

\item{is.non.negative}{logical; tell the penalty function if the data is from
a non-negative distribution;
by default it sets it to \code{TRUE} if the distribution is not a location but a scale family.
 If \code{TRUE}, the penalty can be computed; otherwise, it returns \code{NA}.}

\item{input.bounds}{interval; the bounds of the input distribution. If
\code{is.non.negative = FALSE}, then it will adjust it to \code{c(0, Inf)};
also useful for bounded input distributions, such as \code{"unif"}}
}
\value{
A vector of length 2 with names \code{'lower'} and \code{'upper'}.
}
\description{
If the input \eqn{X \sim F} has support on the entire real line
\eqn{(-\infty, \infty)}, then the skewed Lambert W \eqn{\times} F
distribution has truncated support \eqn{[a,b]}, \eqn{a,b \in R \cup \pm
\infty} depending on \eqn{\boldsymbol \beta} and (the sign of) \eqn{\gamma}.

For scale-families no truncation occurs.
}
\details{
Half-open interval on the real line (if \eqn{\gamma \neq 0}) for
input with support on the entire real line. For \eqn{\gamma = 0} the support
of Y is the same as for X. Heavy-tail Lambert W RVs are not affected by
truncated support (since \eqn{\delta \geq 0} by definition); thus
support is \code{c(lower = -Inf, upper = Inf)}.
}
\examples{
get_support(c(mu_x = 0, sigma_x = 1, gamma = 0)) # as gamma = 0
# truncated on the left since gamma > 0
get_support(c(mu_x = 0, sigma_x = 1, gamma = 0.1))

# no truncation for heavy tail(s)
get_support(c(mu_x = 0, sigma_x = 1, delta = 0.1))
}
\keyword{math}

