% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viterbi.R
\name{viterbi}
\alias{viterbi}
\title{Viterbi algorithm for decoding states}
\usage{
viterbi(delta, Gamma, allprobs)
}
\arguments{
\item{delta}{Initial or stationary distribution of length N}

\item{Gamma}{Transition probability matrix of dimension c(N,N)}

\item{allprobs}{Matrix of state-dependent probabilities/ density values of dimension c(n, N)}
}
\value{
Vector of decoded states of length n
}
\description{
Viterbi algorithm for decoding states
}
\examples{
delta = c(0.5, 0.5)
Gamma = matrix(c(0.9, 0.1, 0.2, 0.8), nrow = 2, byrow = TRUE)
allprobs = matrix(runif(200), nrow = 100, ncol = 2)
states = viterbi(delta, Gamma, allprobs)
}
