% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_one.R
\name{zero_one}
\alias{zero_one}
\alias{label_zero_one}
\title{Zero-one transformation for categorical variable}
\usage{
zero_one(x, one)

label_zero_one(P)
}
\arguments{
\item{x}{a categorical variable}

\item{one}{character string specifying the level that gets mapped to 1.}

\item{P}{A ggplot2 object made by \code{model_plot()} or \code{point_plot()}}
}
\value{
A numerical vector of 0s and 1s.
}
\description{
A convenience function for handling categorical response variables.
Ordinarily, ggplot2 maps categorical levels to numerical values 1, 2, ....
Such numerical mapping is inappropriate for logistic modeling, where we want the levels to
be on a probability scale.
}
\examples{
Birdkeepers |>
  point_plot(zero_one(LC, one="LungCancer") ~ AG + BK, annot = "model")

Birdkeepers |>
  mutate(Condition = zero_one(LC, one = "LungCancer")) |>
  point_plot(Condition ~ AG + BK, annot = "model") |>
  label_zero_one() |>
  add_plot_labels(x="age", color = "Birdkeeper?")
}
