% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_parallel_utils.R
\name{call_llm_par}
\alias{call_llm_par}
\title{Parallel LLM Processing with Tibble-Based Experiments (Core Engine)}
\usage{
call_llm_par(
  experiments,
  simplify = TRUE,
  tries = 10,
  wait_seconds = 2,
  backoff_factor = 3,
  verbose = FALSE,
  memoize = FALSE,
  max_workers = NULL,
  progress = FALSE,
  json_output = NULL
)
}
\arguments{
\item{experiments}{A tibble/data.frame with required list-columns 'config' (llm_config objects)
and 'messages' (character vector OR message list).}

\item{simplify}{Whether to cbind 'experiments' to the output data frame or not.}

\item{tries}{Integer. Number of retries for each call. Default is 10.}

\item{wait_seconds}{Numeric. Initial wait time (seconds) before retry. Default is 2.}

\item{backoff_factor}{Numeric. Multiplier for wait time after each failure. Default is 2.}

\item{verbose}{Logical. If TRUE, prints progress and debug information.}

\item{memoize}{Logical. If TRUE, enables caching for identical requests.}

\item{max_workers}{Integer. Maximum number of parallel workers. If NULL, auto-detects.}

\item{progress}{Logical. If TRUE, shows progress bar.}

\item{json_output}{Deprecated. Raw JSON string is always included as raw_response_json.
This parameter is kept for backward compatibility but has no effect.}
}
\value{
A tibble containing all original columns from experiments (metadata, config, messages),
plus new columns: response_text, raw_response_json (the raw JSON string from the API),
success, error_message, duration (in seconds).
}
\description{
Processes experiments from a tibble where each row contains a config and message pair.
This is the core parallel processing function. Metadata columns are preserved.
This function requires setting up the parallel environment using \code{setup_llm_parallel}.
}
\section{Parallel Workflow}{

All parallel functions require the \code{future} backend to be configured.
The recommended workflow is:
\enumerate{
\item Call \code{setup_llm_parallel()} once at the start of your script.
\item Run one or more parallel experiments (e.g., \code{call_llm_broadcast()}).
\item Call \code{reset_llm_parallel()} at the end to restore sequential processing.
}
}

\examples{
\dontrun{
# Simple example: Compare two models on one prompt
cfg1 <- llm_config("openai", "gpt-4.1-nano", Sys.getenv("OPENAI_API_KEY"))
cfg2 <- llm_config("groq", "llama-3.3-70b-versatile", Sys.getenv("GROQ_API_KEY"))

experiments <- tibble::tibble(
  model_id = c("gpt-4.1-nano", "groq-llama-3.3"),
  config = list(cfg1, cfg2),
  messages = "Count the number of the letter e in this word: Freundschaftsbeziehungen "
)

setup_llm_parallel(workers = 2)
results <- call_llm_par(experiments, progress = TRUE)
reset_llm_parallel()

print(results[, c("model_id", "response_text")])

}
}
\seealso{
For setting up the environment: \code{\link{setup_llm_parallel}}, \code{\link{reset_llm_parallel}}.
For simpler, pre-configured parallel tasks: \code{\link{call_llm_broadcast}}, \code{\link{call_llm_sweep}}, \code{\link{call_llm_compare}}.
For creating experiment designs: \code{\link{build_factorial_experiments}}.
}
