% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS.R
\name{est_regressors}
\alias{est_regressors}
\title{Estimate the distribution of regressors, unconditional on the
  change point locations}
\usage{
est_regressors(rho_dist, data, formula, timename, weights,
  control = list())
}
\arguments{
\item{rho_dist}{List of saved data objects from the ptMCMC estimation of
change point locations (unless \code{nchangepoints} is 0, then 
\code{NULL}) returned from \code{\link{est_changepoints}}.}

\item{data}{\code{data.frame} including [1] the time variable (indicated 
in \code{timename}), [2] the predictor variables (required by
\code{formula}) and [3], the multinomial response variable (indicated in
\code{formula}) as verified by \code{\link{check_timename}} and 
\code{\link{check_formula}}. Note that the response variables should be
formatted as a \code{data.frame} object named as indicated by the 
\code{response} entry in the \code{control} list, such as \code{gamma} 
for a standard TS analysis on LDA output.}

\item{formula}{\code{\link[stats]{formula}} defining the regression between
relationship the change points. Any 
predictor variable included must also be a column in 
\code{data} and any (multinomial) response variable must be a set of
columns in \code{data}, as verified by \code{\link{check_formula}}.}

\item{timename}{\code{character} element indicating the time variable
used in the time series.}

\item{weights}{Optional class \code{numeric} vector of weights for each 
document. Defaults to \code{NULL}, translating to an equal weight for
each document. When using \code{multinom_TS} in a standard LDATS 
analysis, it is advisable to weight the documents by their total size,
as the result of \code{\link[topicmodels]{LDA}} is a matrix of 
proportions, which does not account for size differences among documents.
For most models, a scaling of the weights (so that the average is 1) is
most appropriate, and this is accomplished using \code{document_weights}.}

\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}.}
}
\value{
\code{matrix} of draws (rows) from the marginal posteriors of the 
  coefficients across the segments (columns).
}
\description{
This function uses the marginal posterior distributions of
  the change point locations (estimated by \code{\link{est_changepoints}})
  in combination with the conditional (on the change point locations) 
  posterior distributions of the regressors (estimated by
  \code{\link{multinom_TS}}) to estimate the marginal posterior 
  distribution of the regressors, unconditional on the change point 
  locations.
}
\details{
The general approach follows that of Western and Kleykamp
  (2004), although we note some important differences. Our regression
  models are fit independently for each chunk (segment of time), and 
  therefore the variance-covariance matrix for the full model 
  has \code{0} entries for covariances between regressors in different
  chunks of the time series. Further, because the regression model here
  is a standard (non-hierarchical) softmax (Ripley 1996, Venables and 
  Ripley 2002, Bishop 2006), there is no error term in the regression  
  (as there is in the normal model used by Western and Kleykamp 2004), 
  and so the posterior distribution used here is a multivariate normal,
  as opposed to a multivariate t, as used by Western and Kleykamp (2004).
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  formula <- gamma ~ 1
  nchangepoints <- 1
  control <- TS_control()
  data <- data[order(data[,"newmoon"]), ]
  rho_dist <- est_changepoints(data, formula, nchangepoints, "newmoon", 
                               weights, control)
  eta_dist <- est_regressors(rho_dist, data, formula, "newmoon", weights, 
                             control)
}

}
\references{
Bishop, C. M. 2006. \emph{Pattern Recognition and Machine Learning}. 
   Springer, New York, NY, USA.

  Ripley, B. D. 1996. \emph{Pattern Recognition and Neural Networks}. 
  Cambridge University Press, Cambridge, UK.

  Venables, W. N. and B. D. Ripley. 2002. \emph{Modern and Applied
  Statistics with S}. Fourth Edition. Springer, New York, NY, USA.

  Western, B. and M. Kleykamp. 2004. A Bayesian change point model for 
  historical time series analysis. \emph{Political Analysis}
  \strong{12}:354-374.
  \href{https://doi.org/10.1093/pan/mph023}{link}.
}
