% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImgSeg.R
\name{GetSegImage}
\alias{GetSegImage}
\title{Perform image segmentation}
\usage{
GetSegImage(ImgMat, p1, p2)
}
\arguments{
\item{ImgMat}{- a matrix whose entries are pixel values of the image.}

\item{p1}{- a known value of white pixel (usually 1).}

\item{p2}{- a known value of black pixel (usually 0).}
}
\value{
A list of information of a segmented image.
\itemize{
 \item SegImgMat - a matrix as a result of the image segmentation.
 \item Estimated_S1 - an n1x2 matrix whose entries denote estimated coordinates of white pixels, corresponding to p1.
 \item Estimated_S2 - an n2x2 matrix whose entries denote estimated coordinates of black pixels, corresponding to p2.
}
}
\description{
Seperate an area of white pixels from a given image when there is some noise.
}
\examples{


######## Generate a 10x10 black-and-white rectangle image with some noise
nx=10
ny=10
Type=1
bNoise=TRUE
sig_noise=0.1
lst = GenImg(nx,ny,Type, bNoise, sig_noise)
ImgMat = lst$ImgMat
image(ImgMat, axes = FALSE, col = grey(seq(0, 1, length = 256)))

######## Perform image segmentation
p1=1     ### value of a white pixel
p2=0     ### value of a black pixel


lst = GetSegImage(ImgMat, p1, p2)
EstImgMat = lst$SegImgMat
image(EstImgMat, axes = FALSE, col = grey(seq(0, 1, length = 256)))


}
