% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kg_use_palette.R
\name{kg_get_color}
\alias{kg_get_color}
\alias{kg_get_palette}
\title{Get color palette data}
\usage{
kg_get_color(n = 5, name = "Sapporo_Sta", alpha = 1)

kg_get_palette(name = "Sapporo_Sta", alpha = 1)
}
\arguments{
\item{n}{Number of colors to create.}

\item{name}{color palette name. (default: \code{"Sapporo_Sta"})}

\item{alpha}{The alpha transparency. Numbers range from 0-1. see argument
alpha in \code{\link[grDevices]{rgb}}.}
}
\value{
Vector containing a hex color code representation for the chosen
palette.
}
\description{
\code{kg_get_color} This function creates a vector of \code{n} color palette
data for the KaradaColor Package.
}
\examples{
library("scales")
show_col(kg_get_color(n = 20, name = "Totan", alpha = 0.5))

library("aRtsy")
set.seed(1234)
canvas_strokes(colors = kg_get_color(name = "Otaru_Unga"),
               neighbors = 1, p = 0.02, iterations = 1,
               resolution = 350)
}
