% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllKEPT.R
\name{EllKEPT}
\alias{EllKEPT}
\title{Kernel embedding of probability test for elliptical distribution}
\usage{
EllKEPT(
  X,
  eps = 1e-06,
  kerU = "Gaussian",
  kerTheta = "Gaussian",
  gamma.U = 0,
  gamma.Theta = 0
)
}
\arguments{
\item{X}{A matrix with n rows and d columns.}

\item{eps}{The regularization constant added to the diagonal to avoid
singularity. Default value is \code{1e-6}.}

\item{kerU}{The type of kernel function on \code{U}. Currently supported
options are \code{"Gaussian"} and \code{"PIQ"}.}

\item{kerTheta}{The type of kernel function on \code{Theta}. Currently
supported options are \code{"Gaussian"} and \code{"PIQ"}.}

\item{gamma.U}{The tuning parameter \code{gamma} in the kernel function
k_U(u1,u2). If \code{gamma.U=0}, the recommended procedure of selecting
tuning parameter will be applied. Otherwise, the value given in
\code{gamma.U} will be directly used as the tuning parameter. Default value
is \code{gamma.U=0}. See "Details" for more information.}

\item{gamma.Theta}{The tuning parameter \code{gamma} in the kernel function
k_Theta(theta1,theta2). If \code{gamma.Theta=0}, the recommended procedure
of selecting tuning parameter will be applied. Otherwise, the value given in
\code{gamma.Theta} will be directly used as the tuning parameter. Default
value is \code{gamma.Theta=0}. See "Details" for more information.}
}
\value{
A list of the following:
\item{stat}{The value of the test statistic.}
\item{pval}{The p-value of the test.}
\item{lambda}{The \code{n} eigenvalues in the approximated asymptotic
distribution.}
\item{gamma.U}{The tuning parameter \code{gamma.U} used in the test. Same as
the input if its input is nonzero.}
\item{gamma.Theta}{The tuning parameter \code{gamma.Theta} used in the test.
Same as the input if its input is nonzero.}
}
\description{
This function gives a test on whether the data is elliptically distributed
based on kernel embedding of probability. See Tang and Li (2024) for
details. Gaussian kernels and product-type inverse quadratic kernels are
considered.
}
\details{
The Gaussian kernel is defined as k(z1,z2)=exp(-gamma*||z1-z2||^2), and the
Product-type Inverse-Quadratic (\code{PIQ}) kernel is defines as
k(z1,z2)=Prod_j(1/(1+gamma*(z1_j-z2_j)^2)). The recommended procedure of
selecting tuning parameter is given as in the simulation section of Tang and
Li (2023+), where we set
1/sqrt(gamma)=(n(n-1)/2)^(-1)*sum_\{1<=i<j<=n\}||Z_i-Z_j||.
}
\note{
In the arguments, \code{eps} refers to a regularization constant added to
the diagonal. When the dimension is high, we recommend increasing \code{eps}
to avoid singularity.
}
\examples{
set.seed(313)
n=50
d=3

## Null Hypothesis
X=matrix(rnorm(n*d),nrow=n,ncol=d)
EllKEPT(X)

## Alternative Hypothesis
X=matrix(rchisq(n*d,2)-2,nrow=n,ncol=d)
EllKEPT(X)

}
\references{
\cite{Tang, Y. and Li, B. (2024), “A nonparametric test for elliptical
distribution based on kernel embedding of probabilities,”
\url{https://arxiv.org/abs/2306.10594}}
}
