% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_samples.R
\name{add_samples}
\alias{add_samples}
\title{Continue sampling from an object of class JointAI}
\usage{
add_samples(object, n.iter, add = TRUE, thin = NULL,
  monitor_params = NULL, progress.bar = "text", mess = TRUE)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{n.iter}{the number of additional iterations of the MCMC chain}

\item{add}{logical; should the new MCMC samples be added to the existing
samples (\code{TRUE}; default) or replace them?
If samples are added the arguments \code{monitor_params} and
\code{thin} are ignored.}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}});
ignored when \code{add = TRUE}.}

\item{monitor_params}{named list or vector specifying which parameters should
be monitored. For details, see
\code{\link[JointAI:model_imp]{*_imp}} and the vignette
\href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}.
Ignored when \code{add = TRUE}.}

\item{progress.bar}{character string specifying the type of
progress bar. Possible values are "text" (default), "gui",
and "none" (see \code{\link[rjags]{update}}). Note: when
sampling is performed in parallel it is not possible to
display a progress bar.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}
}
\description{
This function continues the sampling from the MCMC chains of an existing
object of class 'JointAI'.\cr
}
\examples{
# Example 1:
# Run an initial JointAI model:
mod <- lm_imp(y ~ C1 + C2, data = wideDF, n.iter = 100)

# Continue sampling:
mod_add <- add_samples(mod, n.iter = 200, add = TRUE)


# Example 2:
# Continue sampling, but additionally sample imputed values.
# Note: Setting different parameters to monitor than in the original model
# requires add = FALSE.
imps <- add_samples(mod, n.iter = 200, monitor_params = c("imps" = TRUE),
                    add = FALSE)

}
\seealso{
\code{\link[JointAI:model_imp]{*_imp}}

The vignette
\href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
contains some examples on how to specify the argument \code{monitor_params}.
}
