% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence_criteria.R
\name{MC_error}
\alias{MC_error}
\alias{plot.MCElist}
\title{Monte Carlo error}
\usage{
MC_error(x, subset = "main", start = NULL, end = NULL, thin = NULL,
  digits = 2, ...)

\method{plot}{MCElist}(x, scaled = TRUE, plotpars = NULL,
  ablinepars = list(v = 0.05), ...)
}
\arguments{
\item{x}{object inheriting from class \code{JointAI}}

\item{subset}{subset of monitored parameters (columns in the MCMC sample).
Can be specified as a numeric vector of columns, a vector of
column names, as \code{subset = "main"} or \code{NULL}.
If \code{NULL}, all monitored nodes will be plotted.
\code{subset = "main"} (default) the main parameters of the
analysis model will be plotted (regression coefficients/fixed
effects, and, if available, standard deviation of the residual
and random effects covariance matrix).}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{digits}{number of digits for output}

\item{...}{Arguments passed on to \code{mcmcse::mcse.mat}
\describe{
  \item{size}{the batch size. The default value is
  \dQuote{\code{sqroot}}, which uses the square root of the
  sample size. \dQuote{\code{cuberoot}} will cause the
  function to use the cube root of the sample size. A
  numeric value may be provided if neither
  \dQuote{\code{sqroot}} nor \dQuote{\code{cuberoot}} is
  satisfactory.}
  \item{g}{a function such that \eqn{E(g(x))} is the
  quantity of interest. The default is \code{NULL}, which
  causes the identity function to be used.}
  \item{method}{the method used to compute the standard
  error. This is one of \dQuote{\code{bm}} (batch means,
  the default), \dQuote{\code{obm}} (overlapping batch
  means), \dQuote{\code{tukey}} (spectral variance method
  with a Tukey-Hanning window), or \dQuote{\code{bartlett}}
  (spectral variance method with a Bartlett window).}
}}

\item{scaled}{use the scaled or unscaled version, default is \code{TRUE}}

\item{plotpars}{optional; list of parameters passed to \code{\link[graphics]{plot}()}}

\item{ablinepars}{optional; list of parameters passed to \code{\link[graphics]{abline}()}}
}
\value{
an object of class \code{MCElist} with elements \code{unscaled},
        \code{scaled} and \code{digits}. The first two are matrices with
        columns \code{est} (posterior mean), \code{MCSE} (Monte Carlo error),
        \code{SD} (posterior standard deviation) and \code{MCSE/SD}
        (Monte Carlo error divided by post. standard deviation.)
}
\description{
Calculate and plot the Monte Carlo error of the samples from a JointAI model
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: plot Monte Carlo error
}}

\note{
Lesaffre & Lawson (2012) [p. 195] suggest the Monte Carlo error of a
      parameter should not be more than 5\% of the posterior standard
      deviation of this parameter (i.e., \eqn{MCSE/SD \le 0.05}).
}
\examples{
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)
MC_error(mod)


}
\references{
Lesaffre, E., & Lawson, A. B. (2012).
\emph{Bayesian Biostatistics}.
John Wiley & Sons.
}
