/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import antlr.collections.AST;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Parser.AntlrParser.OmegaTokenTypes;
import org.omegahat.Environment.Parser.Parse.ArrayAccess;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.NumberExpression;

public class UnaryExpression
extends NumberExpression
implements ExpressionInt,
OmegaTokenTypes {
    protected int operation;
    protected Object expression;

    public UnaryExpression(Object object, int n) {
        this.operation = n;
        this.expression = object;
    }

    public boolean asBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return true;
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        Object object = null;
        Object var3_3 = null;
        if (this.expression instanceof String) {
            object = evaluator.get((String)this.expression);
        } else if (!(this.expression instanceof ArrayAccess)) {
            object = this.expression instanceof ExpressionInt ? ((ExpressionInt)this.expression).eval(evaluator) : this.expression;
        }
        if (object == null) {
            throw new Exception();
        }
        object = this.operate(object);
        return object;
    }

    public Object expression() {
        return this.expression;
    }

    public Object expression(Object object) {
        this.expression = object;
        return this.expression();
    }

    public AST getFirstChild() {
        return (AST)this.expression;
    }

    public boolean isReassignment() {
        return this.op() == 143 || this.op() == 144;
    }

    public int op() {
        return this.operation;
    }

    public int op(int n) {
        this.operation = n;
        return this.op();
    }

    public String opString() {
        String string;
        switch (this.op()) {
            case 143: {
                string = "++";
                break;
            }
            case 144: {
                string = "--";
                break;
            }
            case 137: {
                string = "-";
                break;
            }
            case 136: {
                string = "-";
                break;
            }
            case 146: {
                string = "!";
                break;
            }
            case 145: {
                string = "~";
                break;
            }
            default: {
                string = "<Unknown operator>";
            }
        }
        return string;
    }

    public Object operate(Object object) {
        switch (this.op()) {
            case 146: {
                boolean bl = this.asBoolean(object);
                object = new Boolean(!bl);
                break;
            }
            case 137: {
                if (object instanceof Integer) {
                    object = new Integer(-1 * (int)NumberExpression.asNumber(object));
                } else if (object instanceof Double) {
                    object = new Double(-1.0 * NumberExpression.asNumber(object));
                } else if (object instanceof BigInteger) {
                    object = ((BigInteger)object).negate();
                } else if (object instanceof BigDecimal) {
                    object = ((BigDecimal)object).negate();
                } else if (object.getClass().isArray()) {
                    int n = Array.getLength(object);
                    Class<?> clazz = object.getClass();
                    Object object2 = Array.newInstance(clazz.getComponentType(), n);
                    int n2 = 0;
                    while (n2 < n) {
                        Object object3 = Array.get(object, n2);
                        if (object3 instanceof Integer) {
                            object3 = new Integer(-1 * (int)NumberExpression.asNumber(object3));
                        } else if (object3 instanceof Double) {
                            object3 = new Double(-1.0 * NumberExpression.asNumber(object3));
                        } else if (object3 instanceof Long) {
                            object3 = new Long(-1L * (long)NumberExpression.asNumber(object3));
                        } else if (object3 instanceof BigInteger) {
                            object3 = ((BigInteger)object3).negate();
                        } else if (object instanceof BigDecimal) {
                            object3 = ((BigDecimal)object3).negate();
                        }
                        Array.set(object2, n2, object3);
                        ++n2;
                    }
                    object = object2;
                } else {
                    throw new RuntimeException("Don't understand how to negate " + object.getClass());
                }
                return object;
            }
            case 136: {
                return object;
            }
            case 145: {
                int n = (int)NumberExpression.asNumber(object);
                return new Integer(n ^= 0xFFFFFFFF);
            }
            default: {
                return object;
            }
        }
        return object;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(this.opString()) + this.expression;
        return string;
    }
}

