% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{findSigRegions}
\alias{findSigRegions}
\title{Function to find significant regions from an interaction}
\usage{
findSigRegions(
  object,
  l1,
  l2,
  name.vary,
  lower,
  upper,
  alpha = 0.05,
  starts = 50
)
}
\arguments{
\item{object}{A fitted rms object}

\item{l1}{the first set of values to fix for the contrast function}

\item{l2}{the second set of values to fix for the contrast function}

\item{name.vary}{the name of the model parameter to vary values for
to find the threshold.  Note that this should not be included in
\code{l1} or \code{l2} arguments.}

\item{lower}{The lower bound to search for values for the varying value}

\item{upper}{The upper bound to search for values for the varying value}

\item{alpha}{The significance threshold, defaults to \code{.05}}

\item{starts}{Number of starting values to try between the
lower and upper bounds.}
}
\value{
A data table with notes if no convergence or significance
  thresholds (if any).
}
\description{
This function uses the \code{contrast} function from \pkg{rms} to
find the threshold for significance from interactions.
}
\examples{
## make me
}
