% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{detailedTests}
\alias{detailedTests}
\title{drop1 for both fixed and random effects}
\usage{
detailedTests(obj, method = c("Wald", "profile", "boot"), ...)
}
\arguments{
\item{obj}{A \code{merMod} class object, the fitted result of
\code{lmer}.}

\item{method}{A character vector indicating the types of confidence
intervals to calculate. One of \dQuote{Wald}, \dQuote{profile}, or
\dQuote{boot}.}

\item{\ldots}{Additional arguments passed to \code{confint}}
}
\description{
This function extends the current \code{drop1} method for
\code{merMod} class objects from the lme4 package. Where
the default method to be able to drop both fixed and random
effects at once.
}
\details{
At the moment, the function is aimed to \code{lmer} models
and has very few features for \code{glmer} or \code{nlmer}
models. The primary motivation was to provide a way to
provide an overall test of whether a variable
\dQuote{matters}.  In multilevel data, a variable may be
included in both the fixed and random effects. To provide
an overall test of whether it matters requires jointly testing
the fixed and random effects. This also is needed to provide
an overall effect size.

The function works by generating a formula with one specific
variable or \dQuote{term} removed at all levels. A model is then
fit on this reduced formula and compared to the full model passed
in. This is a complex operation for mixed effects models for several
reasons. Firstly, \code{R} has no default mechanism for dropping
terms from both the fixed and random portions. Secondly,
mixed effects models do not accomodate all types of models. For example,
if a model includes only a random slope with no random intercept,
if the random slope was dropped, there would be no more random effects,
and at that point, \code{lmer} or \code{glmer} will not run the model.
It is theoretically possible to instead fit the model using
\code{lm} or \code{glm} but this becomes more complex for certain
model comparisons and calculations and is not currently implemented.
Marginal and conditional R2 values are calculated for each term,
and these are used also to calculate something akin to an
f-squared effect size.

This is a new function and it is important to carefully evaluate
the results and check that they are accurate and that they are
sensible. Check accuracy by viewing the model formulae for each
reduced model and checking that those are indeed accurate.
In terms of checking whether a result is sensible or not,
there is a large literature on the difficulty interpretting
main effect tests in the presence of interactions. As it is
challenging to detect all interactions, especially ones that are
made outside of \code{R} formulae, all terms are tested. However,
it likely does not make sense to report results from dropping a
main effect but keeping the interaction term, so present
and interpret these with caution.
}
\examples{

\dontrun{
data(aces_daily)
m1 <- lme4::lmer(NegAff ~ STRESS + (1 + STRESS | UserID),
  data = aces_daily)
m2 <- lme4::lmer(NegAff ~ STRESS + I(STRESS^2) + (1 + STRESS | UserID),
  data = aces_daily)
testm1 <- detailedTests(m1, method = "profile")
testm2 <- detailedTests(m2, method = "profile")
testm2b <- detailedTests(m2, method = "boot", nsim = 100)
}
}
