% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sugar.R
\docType{data}
\name{Sugar}
\alias{Sugar}
\title{Sugar Processing Data}
\format{
A list consisting of the following:
\describe{
\item{\code{y}}{a 268 x 3 matrix of quality parameters: \code{date}, \code{color}, \code{ash}*1000}
\item{\code{X}}{fluoresence array, 268 (observations) x [571 (emission channels) x 7 (excitation channels)]}
\item{\code{Lab}}{Lab information}
\item{\code{DimX}}{array dimension for \code{X}}
\item{\code{Yidx}}{names (id) for \code{y}}
\item{\code{EmAx}}{Emmission levels for axis (nm)}
\item{\code{ExAx}}{Excitation levels for axis (nm)}
\item{\code{time}}{ }
\item{\code{readmetime}}{ }
\item{\code{Lname}}{ }
\item{\code{LabNumber}}{ }
\item{\code{ProcNumber}}{ }
\item{\code{Proc}}{ }
\item{\code{DimLab}}{ }
\item{\code{DimProc}}{ }}
}
\source{
\url{ http://www.models.kvl.dk/Sugar_Process}
}
\usage{
data(Sugar)
}
\description{
Sugar was sampled continuously during eight hours to make
a mean sample representative for one "shift"
(eight hour period). Samples were taken during the
three months of operation (the so-called campaign) in
late autumn from a sugar plant in Scandinavia giving a
total of 268 samples. The sugar was sampled directly
from the final unit operation (centrifuge) of the process.
}
\references{
R. Bro, Exploratory study of sugar production using fluorescence spectroscopy and multi-way analysis,
\emph{Chemom. Intell. Lab. Syst.}, 1999, (46), 133-147.
}
\keyword{datasets}
