% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/j4rFunctions.R
\name{createJavaObject}
\alias{createJavaObject}
\title{Create Java objects}
\usage{
createJavaObject(class, ..., isNullObject = FALSE, isArray = FALSE)
}
\arguments{
\item{class}{the Java class of the object (e.g. java.util.ArrayList)}

\item{...}{the parameters to be passed to the constructor of the object}

\item{isNullObject}{a logical that indicates whether the instance should be null (by default it is set to FALSE)}

\item{isArray}{a logical that indicates whether the instance is an array. By default, it is set to FALSE. When creating an array, the parameters must be integers that define the dimensions of the array}
}
\value{
a java.object or java.list instance in the R environment
}
\description{
This function creates one or many object of a particular class. If the parameters
contain vectors, then a series of instances of this class can be created.
}
\examples{
### starting Java
connectToJava()

### creating an empty ArrayList object
createJavaObject("java.util.ArrayList")

### creating an ArrayList instance with initial capacity of 3
createJavaObject("java.util.ArrayList", as.integer(3))

### creating two ArrayList with different capacities
createJavaObject("java.util.ArrayList", c(as.integer(3), as.integer(4)))

### creating a 3x3 array of integers
myArray <- createJavaObject("int", 3, 3, isArray = TRUE)

### creating two arrays of integers with length 3
myArrays <- createJavaObject("int", c(3,3), isArray = TRUE)

### shutting down Java
shutdownJava()

}
\seealso{
\href{https://sourceforge.net/p/repiceasource/wiki/J4R/}{J4R webpage}
}
