/*
 * Decompiled with CFR 0.152.
 */
package j4r.net.server;

import j4r.app.AbstractGenericEngine;
import j4r.net.SocketWrapper;
import j4r.net.TCPSocketWrapper;
import j4r.net.server.ClientThread;
import j4r.net.server.ServerConfiguration;
import j4r.net.server.ServerTask;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractServer
extends AbstractGenericEngine
implements PropertyChangeListener {
    private ArrayList<ClientThread> clientThreads;
    protected final LinkedBlockingQueue<SocketWrapper> clientQueue;
    private CallReceiverThread callReceiver;
    protected final boolean isCallerAJavaApplication;
    private final ServerConfiguration configuration;
    private List<PropertyChangeListener> listeners;

    protected AbstractServer(ServerConfiguration configuration, boolean isCallerAJavaApplication) throws Exception {
        this.configuration = configuration;
        this.isCallerAJavaApplication = isCallerAJavaApplication;
        this.clientThreads = new ArrayList();
        this.clientQueue = new LinkedBlockingQueue();
        try {
            this.callReceiver = new CallReceiverThread(new ServerSocket(configuration.outerPort), this.clientQueue, configuration.maxSizeOfWaitingList);
            int i = 0;
            while (i < configuration.numberOfClientThreads) {
                this.clientThreads.add(this.createClientThread(this, i + 1));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("Unable to initialize the server");
        }
        this.listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    }

    protected abstract ClientThread createClientThread(AbstractServer var1, int var2);

    protected synchronized SocketWrapper getWaitingClients() throws InterruptedException {
        SocketWrapper socket = this.clientQueue.take();
        return socket;
    }

    protected void listenToClients() {
        for (ClientThread thread : this.clientThreads) {
            thread.start();
        }
    }

    protected void startReceiverThread() throws ExecutionException, InterruptedException {
        System.out.println("Server starting");
        this.callReceiver.start();
        this.listenToClients();
    }

    protected ServerConfiguration getConfiguration() {
        return this.configuration;
    }

    protected List<ClientThread> getClientThreads() {
        return this.clientThreads;
    }

    protected void closeAndRestartTheseThreads(Collection<ClientThread> connectionsToBeClosed) {
        for (ClientThread thread : connectionsToBeClosed) {
            try {
                thread.getSocket().close();
                thread.restartAction();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void firstTasksToDo() {
        this.addTask(new ServerTask(ServerTask.ServerTaskID.StartReceiverThread, this));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent("Server event", propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("shutdownServer")) {
            this.requestShutdown();
        }
    }

    @Override
    public void requestShutdown() {
        block12: {
            this.callReceiver.shutdownCall = true;
            this.callReceiver.clientQueue.clear();
            try {
                try {
                    if (this.callReceiver.serverSocket != null) {
                        this.callReceiver.serverSocket.close();
                    }
                }
                catch (IOException e) {
                    this.callReceiver.interrupt();
                    try {
                        this.callReceiver.join(5000L);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.callReceiver.join(5000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                this.callReceiver.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.requestShutdown();
    }

    private class CallReceiverThread
    extends Thread {
        private boolean shutdownCall = false;
        protected final ServerSocket serverSocket;
        private final LinkedBlockingQueue<SocketWrapper> clientQueue;

        private CallReceiverThread(ServerSocket serverSocket, LinkedBlockingQueue<SocketWrapper> clientQueue, int maxNumberOfWaitingClients) {
            this.serverSocket = serverSocket;
            this.clientQueue = clientQueue;
            this.setName("Answering calls thread");
        }

        @Override
        public void run() {
            try {
                try {
                    while (!this.shutdownCall) {
                        TCPSocketWrapper clientSocket = new TCPSocketWrapper(this.serverSocket.accept(), AbstractServer.this.isCallerAJavaApplication);
                        clientSocket.writeObject((Object)ServerReply.CallAccepted);
                        this.clientQueue.add(clientSocket);
                    }
                    System.out.println("Call receiver thread shut down");
                }
                catch (Exception e) {
                    if (!this.shutdownCall) {
                        e.printStackTrace();
                    }
                    try {
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static enum ServerReply {
        IAmBusyCallBackLater,
        CallAccepted,
        ClosingConnection,
        RequestReceivedAndProcessed;

    }
}

