% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-mirt.R
\name{irtree_fit_mirt}
\alias{irtree_fit_mirt}
\title{Fit an \code{irtree_model} using mirt}
\usage{
irtree_fit_mirt(
  object = NULL,
  data = NULL,
  link = "logit",
  verbose = interactive(),
  control = control_mirt(),
  improper_okay = FALSE
)
}
\arguments{
\item{object}{Object of class \code{irtree_model}. See \link{irtree_model} for more
information.}

\item{data}{Data frame containing containing one row per respondent and one
column per variable. The variable names must correspond to those used in
\code{object}.}

\item{link}{String specifying the link function. Only \code{logit} is
implemented in mirt.}

\item{verbose}{Logical indicating whether output should be printed to the
console.}

\item{control}{List. The allowed elements of this list depend on the
\code{engine}. Use \code{\link[=control_mirt]{control_mirt()}}, \code{\link[=control_mplus]{control_mplus()}}, or \code{\link[=control_tam]{control_tam()}} for
convenience. Note that the \code{fit()} function does not use \code{...}, but that
you can use the \verb{control_*()} functions to pass additional arguments.}

\item{improper_okay}{Logical indicating whether the model should also be fit
if it is not a proper IR-tree model. Set this only to \code{TRUE} if you really
know what you are doing.}
}
\description{
This function takes a \code{data} frame and a model \code{object} and runs the model in mirt.
}
\keyword{internal}
