% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportIncidencePrevalenceResults.R
\name{exportIncidencePrevalenceResults}
\alias{exportIncidencePrevalenceResults}
\title{Export IncidencePrevalence results}
\usage{
exportIncidencePrevalenceResults(resultList, zipName, outputFolder)
}
\arguments{
\item{resultList}{Named list with results from estimateIncidence,
estimatePointPrevalence, or estimatePeriodPrevalence}

\item{zipName}{name to give zip folder}

\item{outputFolder}{directory to save zip folder containing results as a set
of CSV files}
}
\value{
zip folder of results saved in the outputFolder
}
\description{
Export IncidencePrevalence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator"
)
prev <- estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
exportIncidencePrevalenceResults(
  resultList = list("prevalence" = prev),
  zipName = "test",
  outputFolder = tempdir()
)
}
}
