/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SelectedSparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;

class SelectedSparseDoubleMatrix3D
extends DoubleMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongDoubleMap elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseDoubleMatrix3D(AbstractLongDoubleMap abstractLongDoubleMap, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = abstractLongDoubleMap;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    public double getQuick(int n, int n2, int n3) {
        return this.elements.get((long)this.offset + (long)this.sliceOffsets[this.sliceZero + n * this.sliceStride] + (long)this.rowOffsets[this.rowZero + n2 * this.rowStride] + (long)this.columnOffsets[this.columnZero + n3 * this.columnStride]);
    }

    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    public DoubleMatrix3D like(int n, int n2, int n3) {
        return new SparseDoubleMatrix3D(n, n2, n3);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public void setQuick(int n, int n2, int n3, double d) {
        long l = (long)this.offset + (long)this.sliceOffsets[this.sliceZero + n * this.sliceStride] + (long)this.rowOffsets[this.rowZero + n2 * this.rowStride] + (long)this.columnOffsets[this.columnZero + n3 * this.columnStride];
        if (d == 0.0) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, d);
        }
    }

    public DoubleMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DoubleMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedSparseDoubleMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public DoubleMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseDoubleMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public DoubleMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseDoubleMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D instanceof SelectedSparseDoubleMatrix3D) {
            SelectedSparseDoubleMatrix3D selectedSparseDoubleMatrix3D = (SelectedSparseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == selectedSparseDoubleMatrix3D.elements;
        }
        if (doubleMatrix3D instanceof SparseDoubleMatrix3D) {
            SparseDoubleMatrix3D sparseDoubleMatrix3D = (SparseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == sparseDoubleMatrix3D.elements;
        }
        return false;
    }

    protected DoubleMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    protected DoubleMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseDoubleMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }
}

