% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.r
\name{summary.insilico}
\alias{summary.insilico}
\alias{print.insilico_summary}
\title{Summarizing InSilicoVA Model Fits}
\usage{
\method{summary}{insilico}(object, CI.csmf = 0.95, CI.cond = 0.95,
  file = NULL, top = 10, id = NULL, ...)
}
\arguments{
\item{object}{Fitted \code{"insilico"} object.}

\item{CI.csmf}{Confidence interval for CSMF estimates.}

\item{CI.cond}{Confidence interval for conditional probability estimates}

\item{file}{Optional .csv file to write to. If it is specified, individual
cause of death distribution will be saved to the file.}

\item{top}{Number of top causes to display on screen.}

\item{id}{ID of specific death to display on screen.}

\item{\dots}{Not used.}
}
\value{
\item{id.all}{ all IDs of the deaths.} 
\item{indiv}{ individual Cause of Death distribution matrix.} 
\item{csmf}{ CSMF distribution and confidence interval for each cause.} 
\item{csmf.ordered}{ CSMF distribution and confidence interval for each cause, ordered by mean.} 
\item{condprob}{ Conditional probability matrix and confidence intervals.}
\item{updateCondProb}{Component of \code{"insilico"} object.}
\item{keepProbbase.level}{Component of \code{"insilico"} object.}
\item{datacheck}{Component of \code{"insilico"} object.}
\item{Nsim}{Component of \code{"insilico"} object.}
\item{thin}{Component of \code{"insilico"} object.} \item{burnin}{Component
of \code{"insilico"} object.} 
\item{jump.scale}{Component of \code{"insilico"} object.}
\item{levels.prior}{Component of \code{"insilico"} object.}
\item{levels.strength}{Component of \code{"insilico"} object.}
\item{trunc.min}{Component of \code{"insilico"} object.}
\item{trunc.max}{Component of \code{"insilico"} object.}
\item{subpop_counts}{Component of \code{"insilico"} object.}
\item{showTop}{Component of \code{"insilico"} object.}
}
\description{
This function is the summary method for class \code{insilico}.
}
\details{
\code{summary.insilico} formats some basic information about the InSilicoVA
fitted object on screen and show the several top CSMFs of user's choice. See
below for more detail.
}
\examples{
\dontrun{
# load sample data together with sub-population list
data(RandomVA1)
# extract InterVA style input data
data <- RandomVA1$data
# extract sub-population information. 
# The groups are "HIV Positive", "HIV Negative" and "HIV status unknown".
subpop <- RandomVA1$subpop

# run without subpopulation
fit1<- insilico( data, subpop = NULL, 
              Nsim = 400, burnin = 200, thin = 10 , seed = 1,
              external.sep = TRUE, keepProbbase.level = TRUE)
summary(fit1)
summary(fit1, top = 10)

# save individual COD distributions to files
summary(fit1, file = "results.csv")
}
}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C.
Crampin, Kathleen Kahn and Samuel J. Clark Probabilistic cause-of-death
assignment using verbal autopsies, \emph{arXiv preprint arXiv:1411.3042}
\url{http://arxiv.org/abs/1411.3042} (2014)
}
\seealso{
\code{\link{insilico}}, \code{\link{plot.insilico}}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}
