% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getRegion}
\alias{getRegion}
\title{Get polygons corresponding to regions}
\usage{
getRegion(dat, datType, level, myLandMat = landMat,
  myAllRegions = allRegions, useAll = FALSE, landInd = FALSE,
  xmn = -3850, xmx = 3750, ymn = -5350, ymx = 5850)
}
\arguments{
\item{dat}{matrix of one of the allowed data types ("gfdl", "bootstrap", or "simple)  (see details)}

\item{datType}{string indicating the format of the data: either "gfdl", "bootstrap", or "simple" (see details)}

\item{level}{concentration level of interest}

\item{myLandMat}{binary matrix specifying land locations}

\item{myAllRegions}{\code{SpatialPolygons} object specifying region that will be considered}

\item{useAll}{boolean, if true indicates to use the full area (overrides \code{myLandMat})}

\item{landInd}{boolean, if true indicates that the region of interest is the land}

\item{xmn}{min x (defaults to value for polar stereographic grid, -3850)}

\item{xmx}{max x (defaults to value for polar stereographic grid, 3750)}

\item{ymn}{min y (defaults to value for polar stereographic grid, -5350)}

\item{ymx}{max y (defaults to value for polar stereographic grix, 5850)}
}
\value{
region of interest as a \code{SpatialPolygons} object
}
\description{
Takes in a matrix and returns polygons representing
contiguous regions in the matrix. Typically these regions are either where the ice concentration
is above a certain level or where there is land.
}
\details{
For \code{datType = "simple"}  the values in the \code{dat} matrix are
indicators of whether the grid box contains ice (1: ice-covered, 0: no ice, NA: land).
If \code{datType = "gfdl"} or \code{datType  = "bootstrap"}, the values in the matrix correspond
to the raw ice concentrations values observed or predicted (including indicators for missing data, land etc.).
If \code{datType = "gfdl"}, the predictions are
formatted as in the CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model produced by the National Oceanic and Atmospheric Administration’s
Geophysical Fluid Dynamics Laboratory converted to a Polar Stereographic grid (Vecchi et al. 2014; Msadek et al. 2014).
If \code{datType = "bootstrap"} the array values are formatted the same as the ice concentration values obtaned from the
 National Aeronautics and Space Administration (NASA) satellites Nimbus-7
SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm.
}
\examples{
\dontrun{
obsExample <-  getRegion(dat = obsFeb2012, datType = "bootstrap", level = 15)
plot(land, col = 'grey', border = FALSE)
plot(obsExample, col = "lightblue", add = TRUE)
}
}
\references{
Bootstrap sea ice concentration:
Comiso, J., 2000, updated 2015: Bootstrap sea ice concentrations from Nimbus-7 SMMR and
DMSP SSM/I-SSMIS. version 2. \url{http://nsidc.org/data/nsidc-0079}

CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model:
Vecchi, Gabriel A., et al.
\href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical}
cyclone activity." Journal of Climate 27.21 (2014): 7994-8016.

Msadek, R., et al.
\href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions of Arctic sea ice extent."}
 Geophysical Research Letters 41.14 (2014): 5208-5215.

National Center for Atmospheric Research, 2017: Earth system grid at NCAR. \url{https://www.
earthsystemgrid.org/home.html}.
}
