% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irtpp.R
\name{individual.traits}
\alias{individual.traits}
\title{Estimate the latent traits.}
\usage{
individual.traits(model, itempars, method, dataset = NULL,
  probability_matrix = NULL)
}
\arguments{
\item{model}{The model used to calibrate the parameters.}

\item{itempars}{The item parameters for the model in matrix form.}

\item{method}{The method for estimating the traits, may be "EAP" or "MAP".}

\item{dataset}{The matrix with the responses from the individuals.}

\item{probability_matrix}{The probability matrix in case it does not need to be recalculated.}
}
\value{
A list with the patterns and the estimated latent traits.
}
\description{
Estimate the latent traits of the individuals in a test with some given item parameters.
}
\examples{
## Simulation data for the model "3pl"
# data <- simulateTest(model = "3PL", items = 100, individuals = 1000)
## Estimation of the parameters
# est <- irtpp(data$test, model = "3PL")
## Parameter Matrix 
# z <- parameter.matrix(est$z)
#trait <- individual.traits(model = "3PL", itempars = z, dataset = data$test,
#                  method = "EAP", probability_matrix = est$prob_mat)
}

