% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory.R
\name{polyserial.cor}
\alias{polyserial.cor}
\title{Polyserial correlation}
\usage{
polyserial.cor(x, y)
}
\arguments{
\item{x}{a numeric vector representing the continuous variable.}

\item{y}{a numeric vector representing the dichotomous variable.}
}
\value{
the value of the polyserial correlation.
}
\description{
Polyserial correlation coefficient is a correlation coefficient
used when one variable is continuous and the other variable is dichotomous.
}
\details{
The coefficient is calculated from \deqn{\rho = r_{xy} * \sqrt{(n - 1)/n} * s_y/\sum{\phi(\tau)}}
where $r_{xy}$ is the coefficient of correlation of Pearson coefficient, S_y is the 
standard deviation of Y, and \deqn{\phi(\tau)} are the ordinates of the normal curve at 
the normal equivalent of the cut point boundaries between the item responses.
This function was adapted from ltm_1.0 package.
}
\examples{
 x <- rnorm(100)
 y <- sample(1:5,100,replace=TRUE)
 cor(x, y) 
 polyserial.cor(x, y) 
}
\references{
U.Olsson, F.Drasgow, and N.Dorans (1982). The polyserial correlation coefficient. Psychometrika, 47:337-347.
}

