% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained.R
\name{constrained}
\alias{constrained}
\title{Constrained Precision Matrix}
\usage{
constrained(Sigma, adj)
}
\arguments{
\item{Sigma}{Covariance matrix}

\item{adj}{Matrix with constraints. A zero indicates that element
should be constrained to zero.}
}
\value{
A list containing the inverse covariance matrix and the covariance matrix.
}
\description{
Compute the maximum likelihood estimate, given certain elements are constrained to zero
(e.g., an adjacency matrix). This approach is described in \insertCite{hastie2009elements;textual}{IRCcheck}.
}
\note{
The algorithm is written in \code{c++}.
}
\examples{
# random adj 
# 90 \% sparsity (roughly)
p <- 20
adj <- matrix(sample(0:1, size = p^2, replace = TRUE, 
              prob = c(0.9, 0.1) ), 
              nrow = p, ncol = p)

adj <-  symm_mat(adj)

diag(adj) <- 1

# random correlation matrix
set.seed(1)
cors <- cov2cor(
  solve(
  rWishart(1, p + 2, diag(p))[,,1])
)

# constrain to zero
net <- constrained(cors, adj = adj)

}
\references{
\insertAllCited{}
}
