% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSetList.R
\name{generate_data.ECDF_From_EAF}
\alias{generate_data.ECDF_From_EAF}
\title{Generate dataframe consisting of the ECDF-equivalent based on the EAF}
\usage{
generate_data.ECDF_From_EAF(
  eaf_table,
  min_val,
  max_val,
  maximization = F,
  scale_log = F,
  normalize = T
)
}
\arguments{
\item{eaf_table}{Datatable resulting from the `generate_data.EAF` function}

\item{min_val}{Minimum value to use for y-space}

\item{max_val}{Maximum value to use for y-space}

\item{maximization}{Whether the data resulted from maximization or not}

\item{scale_log}{Whether to use logarithmic scaling in y-space before calculating the partial integral}

\item{normalize}{Whether to normalize the resulting integrals to [0,1] (Based on `min_val` and `max_va`)}
}
\description{
This function uses EAF-data to calculate a target-independent version of the ECDF
}
\examples{
\dontshow{data.table::setDTthreads(1)}
generate_data.ECDF_From_EAF(generate_data.EAF(subset(dsl, funcId == 1)), 1, 16, maximization = TRUE)
}
