% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGAM.R
\name{makeGAM}
\alias{makeGAM}
\title{A function to create the formulae needed to fit GAMs in INLA in R.}
\usage{
makeGAM(varnames, response = "y", invariant = "0 + Intercept",
  linear = TRUE, returnstring = TRUE)
}
\arguments{
\item{varnames}{Character vector giving the names of the variables to be used.}

\item{response}{String giving the name of the response variable}

\item{invariant}{Any string to be invluded at the beginning of the formula such as identifying the intercept}

\item{linear}{If TRUE, all variables are included as linear terms. If a character vector, variables in the 
vector are included as linear terms. If FALSE, no linear terms are included.}

\item{returnstring}{If TRUE, return formula as a string (which can later be turned into a formula with 
\code{\link{formula}}). If FALSE, return a formula object.}
}
\description{
Given the beginning of a formula (e.g. y ~ 0 + Intercept) this function builds the string needed to create 
GAM models either with or withour the linear terms as well.
This can then be returned as a formula (if it is to be used directly) or as a string (if other elements such
as random effects are yet to be added).
}
\examples{
 # GAM formula
 form1 <- makeGAM(c('x1', 'x2'), response = 'y', invariant = '0 + Intercept')
 
 # GAM with additional linear terms
 form2 <- makeGAM(c('x1', 'x2'), response = 'y', invariant = '0 + Intercept', 
                  linear = c('x1', 'x2', 'x3'))
 
 library(INLA)
 data(Epil)
 observed <- Epil[1:30, 'y']
 Epil <- rbind(Epil, Epil[1:30, ])
 Epil[1:30, 'y'] <- NA
 ## make centered covariates
 formula = y ~ Trt + Age + V4 +
          f(Ind, model="iid") + f(rand,model="iid")
 formula <- makeGAM('Age', invariant = '', linear = c('Age', 'Trt', 'V4'), returnstring = FALSE)
 result = inla(formula, family="poisson", data = Epil, 
               control.predictor = list(compute = TRUE, link = 1))
 ggplot_inla_residuals(result, observed, binwidth = 0.2)
 autoplot(result)
}
