% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kronecker.R
\name{kronecker,cgeneric,cgeneric-method}
\alias{kronecker,cgeneric,cgeneric-method}
\alias{kronecker,cgeneric,rgeneric-method}
\alias{kronecker,rgeneric,cgeneric-method}
\alias{kronecker,rgeneric,rgeneric-method}
\title{Kronecker (product) between two \code{cgeneric} models as
a method for \code{\link[=kronecker]{kronecker()}}}
\usage{
\S4method{kronecker}{cgeneric,cgeneric}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

\S4method{kronecker}{cgeneric,rgeneric}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

\S4method{kronecker}{rgeneric,cgeneric}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

\S4method{kronecker}{rgeneric,rgeneric}(X, Y, FUN = "*", make.dimnames = FALSE, ...)
}
\arguments{
\item{X}{\code{cgeneric} or \code{rgeneric}}

\item{Y}{\code{cgeneric} or \code{rgeneric}}

\item{FUN}{see \code{\link[=kronecker]{kronecker()}}}

\item{make.dimnames}{see \code{\link[=kronecker]{kronecker()}}}

\item{...}{see \code{\link[=kronecker]{kronecker()}}}
}
\value{
if 'X' and 'Y' are 'cgeneric' return a
'cgeneric', else a 'rgeneric'.
}
\description{
Kronecker (product) between two \code{cgeneric} models as
a method for \code{\link[=kronecker]{kronecker()}}

Kronecker (product) between a \code{cgeneric} model and
a \code{rgeneric} model as a method for kronecker()

Kronecker (product) between a \code{rgeneric} model and
a \code{cgeneric} model as a method for kronecker()

Kronecker (product) between a \code{rgeneric} model and
a \code{rgeneric} model as a method for kronecker()
}
\examples{
R <- Matrix(crossprod(diff(diag(4))))
m1 <- cgeneric("generic0", R = R, param = c(1, NA),
  scale = FALSE, useINLAprecomp = FALSE)
m2 <- cgeneric("iid", n = 3, param = c(1, 0.5),
  useINLAprecomp = FALSE)
k21 <- kronecker(m2, m1, useINLAprecomp = FALSE)
prec(k21, theta = 0.0)
}
