% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatbot.R
\name{chatbot}
\alias{chatbot}
\title{chatbot Shiny server Module}
\usage{
chatbot(input, output, session, api_key, workspace, rv.chat = FALSE)
}
\arguments{
\item{input}{input variable to read the value from}

\item{output}{output variable to read the value from}

\item{session}{session variable to read the value from}

\item{api_key}{api key to connect to your watson assistant}

\item{workspace}{your watson assistant workspace}

\item{rv.chat}{optional variable to pass your chatbot as a reactive variable}
}
\description{
chatbot Shiny server Module
}
\details{
A shiny server module for the chatbot
}
\examples{
if(interactive()){
## app.R ##
library(shiny)
library(shinydashboard)
library(IMWatson)
ui <- dashboardPage(
dashboardHeader(),
dashboardSidebar(),
dashboardBody(IMWatson::chatbotUI("watson"))
)
server <- function(input, output, session) {
callModule(IMWatson::chatbot, "watson", api_key = your_api_key,
workspace = your_workspace)
 }
 shinyApp(ui, server)
 }
}
