#' IMIFA: Fitting, Diagnostics, and Plotting Functions for Infinite Mixtures of Infinite Factor Analysers and Related Models
#'
#' A package for Bayesian nonparameteric clustering of high-dimensional datasets, providing functions for fitting, diagnostic tools and plotting for Infinite Mixtures of Infinite Factor Analysers and the full suite of related models. Allows model based clustering with factor analytic covariance structures without recourse to model selection criteria to choose the number of clusters or cluster-specific latent factors. Model-specific diagnostic tools are also provided, as well as many options for plotting results and posterior distributions of parameters of inferential interest.
#'
#' @section Usage:
#' The three most important functions in the \pkg{IMIFA} package are: \code{\link{mcmc_IMIFA}}, for fitting the model, \code{\link{get_IMIFA_results}}, for extracting results from objects of the "IMIFA" class generated by \code{\link{mcmc_IMIFA}}, and the dedicated plotting function \code{\link{plot.Results_IMIFA}}, for plotting results pertaining to parameters of inferential interest from objects of class "Results_IMIFA" generated by \code{\link{get_IMIFA_results}}.
#'
#' Other functions also exist for simulating data from a multivariate mixture of factor analysers and for soliciting good priors.
#'
#' @section Details:
#' Package: IMIFA
#'
#' Type: Package
#'
#' Version: 1.3.0
#'
#' Date: 2017-06-22 (this version), 2017-02-02 (original release)
#'
#' Licence: GPL (>=2)
#'
#' \code{\link{mcmc_IMIFA}}:
#' This function estimates models in the IMIFA family under the Bayesian paradigm. Most importantly, one must specify the 'method' in the form of an acronym (e.g. "MIFA" for Mixtures of Infinite Factor Analysers) and ranges of values for range.G, the number of clusters, and range.Q, the number(s) of (cluster-specific) latent factors as required by said method.
#'
#' \code{\link{get_IMIFA_results}}:
#' Raw simulation objects generated by mcmc_IMIFA() are passed to this function in order to extract results of interest and conduct further post-processing if necessary.
#'
#' \code{\link{plot.Results_IMIFA}}:
#' Results obtained from get_IMIFA_Results are passed to this function with the type of plot desired specified by 'plot.meth' (e.g. "trace") and the parameter of interest specified by 'param' (e.g. "loadings").
#'
#' @author
#' Keefe Murphy [aut, cre], Isobel Claire Gormley [ctb], Cinzia Viroli [ctb]
#'
#' Maintainer: Keefe Murphy - \href{keefe.murphy@ucd.ie}{<keefe.murphy@ucd.ie>}
#'
#' @section References:
#' Murphy, K., Gormley, I. C. and Viroli, C. (2017) Infinite Mixtures of Infinite Factor Analysers: Nonparametric Model-Based Clustering via Latent Gaussian Models, \href{https://arxiv.org/abs/1701.07010}{arXiv:1701.07010}
#'
#' @section See Also:
#' Further details and examples are given in the associated vignette document:\cr
#' \code{vignette("IMIFA", package = "IMIFA")}
#' @docType package
#' @name IMIFA
NULL

.onAttach <- function(...) packageStartupMessage(paste("   ________  __________________\n  /_  __/  |/   /_  __/ ___/ _ \\  \n   / / / /|_// / / / / /__/ /_\\ \\ \n _/ /_/ /   / /_/ /_/ ___/ /___\\ \\ \n/____/_/   /_/_____/_/  /_/     \\_\\               version 1.3.0\nType '?IMIFA' to see a brief guide to how to use this R package.\nType", sQuote(paste0("citation(", dQuote("IMIFA"),")")) ,"for citing the package in publications."))
