% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{PGMM_dfree}
\alias{PGMM_dfree}
\title{Estimate the Number of Free Parameters in Finite Factor Analytic Mixture Models (PGMM)}
\usage{
PGMM_dfree(Q, P, G = 1, method = c("UUU", "UUC", "UCU", "UCC", "CUU", "CUC",
  "CCU", "CCC"))
}
\arguments{
\item{Q}{The number of latent factors (which can be 0, corresponding to a model with diagonal covariance). This argument is vectorised.}

\item{P}{The number of variables.}

\item{G}{The number of groups. This defaults to 1.}

\item{method}{By default, calculation assumes the \code{UUU} model with unconstrained loadings and unconstrained isotropic uniquesses. The other seven models detailed in McNicholas and Murphy (2008) are also given. The first letter denotes whether loadings are constrained/unconstrained across groups; the second letter denotes the same for the uniquenesses; the final letter denotes whether uniquenesses are in turn constrained to be isotropic.}
}
\value{
A vector of length \code{length(Q)}.
}
\description{
Estimates the dimension of the 'free' parameters in fully finite factor analytic mixture models, otherwise known as Parsimonious Gaussian Mixture Models (PGMM). This is used to calculate the penalty terms for the \code{aic.mcmc} and \code{bic.mcmc} model selection criteria implemented in \code{\link{get_IMIFA_results}} for \emph{finite} factor models (though \code{\link{mcmc_IMIFA}} currently only implements \code{UUU} and \code{UUC} covariance structures). Please note that while this available as a standalone function, no checks are performed in order to make its use in \code{\link{get_IMIFA_results}} faster.
}
\examples{
UUU <- PGMM_dfree(Q=4:5, P=50, G=3, method="UUU")
CCC <- PGMM_dfree(Q=4:5, P=50, G=3, method="CCC")
}
\references{
McNicholas, P. D. and Murphy, T. B. (2008) Parsimonious Gaussian Mixture Models, \emph{Statistics and Computing}, 18(3): 285-296.
}
\seealso{
\code{\link{get_IMIFA_results}}, \code{\link{mcmc_IMIFA}}
}
