% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MZILN.R
\name{MZILN}
\alias{MZILN}
\title{Conditional regression for microbiome analysis based on multivariate zero-inflated logistic normal model}
\usage{
MZILN(
  MicrobData,
  CovData,
  linkIDname,
  targetTaxa = NULL,
  refTaxa,
  allCov = NULL,
  adjust_method = "BY",
  fdrRate = 0.15,
  paraJobs = NULL,
  bootB = 500,
  taxDropThresh = 0,
  standardize = FALSE,
  sequentialRun = TRUE,
  seed = 1
)
}
\arguments{
\item{MicrobData}{Microbiome data matrix containing microbiome absolute abundance or relative abundance with each row
per sample and each column per taxon/OTU/ASV (or any other unit). It should contain an id variable to
be linked with the id variable in the covariates data: \code{CovData}. This argument can
take directory path. For example, \code{MicrobData="C://...//microbiomeData.tsv"}.}

\item{CovData}{Covariates data matrix containing covariates and confounders with each row
per sample and each column per variable. Any categorical variable should be converted into dummy variables in this data matrix unless it can be treated as a continuous variable.
It should also contain an id variable to
be linked with the id variable in the microbiome data: \code{MicrobData}. This argument can
take directory path. For example, \code{CovData="C://...//covariatesData.tsv"}.}

\item{linkIDname}{The common variable name of the id variable in both \code{MicrobData} and \code{CovData}. The two data sets will be merged by this id variable.}

\item{targetTaxa}{The numerator taxa names specified by users for the targeted ratios. Default is NULL in which case all taxa are numerator taxa (except the taxa in the argument 'refTaxa').}

\item{refTaxa}{Denominator taxa names specified by the user for the targeted ratios. This could be a vector of names.}

\item{allCov}{All covariates of interest (including confounders) for estimating and testing their associations with the targeted ratios. Default is 'NULL' meaning that all covariates in covData are of interest.}

\item{adjust_method}{The adjusting method for p value adjustment. Default is "BY" for dependent FDR adjustment. It can take any adjustment method for p.adjust function in R.}

\item{fdrRate}{The false discovery rate for identifying taxa/OTU/ASV associated with \code{allCov}. Default is \code{0.15}.}

\item{paraJobs}{If \code{sequentialRun} is \code{FALSE}, this specifies the number of parallel jobs that will be registered to run the algorithm. If specified as \code{NULL}, it will automatically detect the cores to decide the number of parallel jobs. Default is \code{NULL}.}

\item{bootB}{Number of bootstrap samples for obtaining confidence interval of estimates for the high dimensional regression. The default is \code{500}.}

\item{taxDropThresh}{The threshold of number of non-zero sequencing reads for each taxon to be dropped from the analysis. The default is \code{0} which means taxon without any sequencing reads will be dropped from the analysis.}

\item{standardize}{This takes a logical value \code{TRUE} or \code{FALSE}. If \code{TRUE}, the design matrix for X will be standardized in the analyses and the results. Default is \code{FALSE}.}

\item{sequentialRun}{This takes a logical value \code{TRUE} or \code{FALSE}. Default is \code{TRUE}. It can be set to be "FALSE" to increase speed if there are multiple taxa in the argument 'refTaxa'.}

\item{seed}{Random seed for reproducibility. Default is \code{1}. It can be set to be NULL to remove seeding.}
}
\value{
A list containing the estimation results.

##' - \code{targettaxa_result_list}: A list containing estimating results for the targeted ratios. Only available when targetTaxa is non-empty.
\itemize{
\item \code{sig_results}: A list containing estimating results for all significant ratios
\item \code{covariatesData}: A dataset containing all covariates used in the analyses.
}
}
\description{
For estimating and testing the associations of abundance ratios with covariates.
\loadmathjax
}
\details{
Most of the time, users just need to feed the first six inputs to the function: \code{MicrobData}, \code{CovData},  \code{linkIDname}, \code{targetTaxa}, \code{refTaxa} and \code{allCov}. All other inputs can just take their default values.
The regression model for \code{MZILN()} can be expressed as follows:
\mjdeqn{\log\bigg(\frac{\mathcal{Y}_i^k}{\mathcal{Y}_i^{K+1}}\bigg)|\mathcal{Y}_i^k>0,\mathcal{Y}_i^{K+1}>0=\alpha^{0k}+\mathcal{X}_i^T\alpha^k+\epsilon_i^k,\hspace{0.2cm}k=1,...,K}{}
where
\itemize{
\item \mjeqn{\mathcal{Y}_i^k}{} is the AA of taxa \mjeqn{k}{} in subject \mjeqn{i}{} in the entire
ecosystem.
\item \mjeqn{\mathcal{Y}_i^{K+1}}{} is the reference taxon (specified by user).
\item \mjeqn{\mathcal{X}_i}{} is the covariate matrix for all covariates including confounders.
\item \mjeqn{\alpha^k}{} is the regression coefficients along with their 95\% confidence intervals that will be estimated by the \code{MZILN()} function.
}

High-dimensional \mjeqn{X_i}{} is handled by regularization.
}
\examples{
data(dataM)
dim(dataM)
dataM[1:5, 1:8]
data(dataC)
dim(dataC)
dataC[1:5, ]
\donttest{
results <- MZILN(MicrobData = dataM,
                CovData = dataC,
                linkIDname = "id",
                targetTaxa = "rawCount6",
                refTaxa=c("rawCount11"),
                allCov=c("v1","v2","v3"),
                fdrRate=0.15)

}



}
\references{
Li et al.(2018) Conditional Regression Based on a Multivariate Zero-Inflated Logistic-Normal Model for Microbiome Relative Abundance Data. Statistics in Biosciences 10(3): 587-608

Zhang CH (2010) Nearly unbiased variable selection under minimax concave penalty. Annals of Statistics. 38(2):894-942.

Liu et al.(2020) A bootstrap lasso + partial ridge method to construct confidence intervals for parameters in high-dimensional sparse linear models. Statistica Sinica
}
