% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MINDID.R
\name{MINDID}
\alias{MINDID}
\title{The (Multipoint) Morisita Index for Intrinsic Dimension Estimation}
\usage{
MINDID(X, scaleQ=1:5, mMin=2, mMax=2)
}
\arguments{
\item{X}{A \eqn{N \times E}{N x E} \code{matrix}, \code{data.frame} or \code{data.table} where \eqn{N} is the number
of data points and \eqn{E} is the number of variables (or features). Each variable
is rescaled to the \eqn{[0,1]} interval by the function.}

\item{scaleQ}{A vector (at least two values). It contains the values of \eqn{\ell^{-1}}{l^(-1)}
chosen by the user (by default: \code{scaleQ = 1:5}).}

\item{mMin}{The minimum value of \eqn{m} (by default: \code{mMin = 2}).}

\item{mMax}{The maximum value of \eqn{m} (by default: \code{mMax = 2}).}
}
\value{
A list of two elements:
 \enumerate{
  \item a \code{data.frame} containing the \eqn{\ln}{ln} value of the m-Morisita index for each value
  of \eqn{\ln (\delta)}{ln(delta)} and \eqn{m}. The values of \eqn{\ln (\delta)}{ln(delta)} are provided with regard to the \eqn{[0,1]} interval.
  \item a \code{data.frame} containing the values of \eqn{S_m}{Sm} and \eqn{M_m}{Mm} for each value of \eqn{m}.
}
}
\description{
Estimates the intrinsic dimension of data using the Morisita estimator of intrinsic dimension.
}
\details{
\enumerate{
\item \eqn{\ell}{l} is the edge length of the grid cells (or quadrats). Since the variables
(and consenquently the grid) are rescaled to the \eqn{[0,1]} interval, \eqn{\ell}{l} is equal
to \eqn{1} for a grid consisting of only one cell.
\item \eqn{\ell^{-1}}{l^(-1)} is the number of grid cells (or quadrats) along each axis of the
Euclidean space in which the data points are embedded.
\item \eqn{\ell^{-1}}{l^(-1)} is equal to \eqn{Q^{(1/E)}}{Q^(1/E)} where \eqn{Q} is the number
of grid cells and \eqn{E} is the number of variables (or features).
\item \eqn{\ell^{-1}}{l^(-1)} is directly related to \eqn{\delta}{delta} (see References).
\item \eqn{\delta}{delta} is the diagonal length of the grid cells.
}
}
\examples{
sim_dat <- SwissRoll(1000)

scaleQ <- 1:15 # It starts with a grid of 1^E cell (or quadrat).
               # It ends with a grid of 15^E cells (or quadrats).
mMI_ID <- MINDID(sim_dat, scaleQ[5:15])

print(paste("The ID estimate is equal to",round(mMI_ID[[1]][1,3],2)))
}
\references{
J. Golay and M. Kanevski (2015). A new estimator of intrinsic dimension
based on the multipoint Morisita index,
\href{http://www.sciencedirect.com/science/article/pii/S0031320315002320}{Pattern Recognition 48 (12):4070–4081}.

J. Golay, M. Leuenberger and M. Kanevski (2017). Feature selection for regression problems based
on the Morisita estimator of intrinsic dimension,
\href{http://www.sciencedirect.com/science/article/pii/S0031320317301905}{Pattern Recognition 70:126–138}.

J. Golay and M. Kanevski (2017). Unsupervised feature selection based on the
Morisita estimator of intrinsic dimension,
\href{http://www.sciencedirect.com/science/article/pii/S0950705117303659}{Knowledge-Based Systems 135:125-134}.

J. Golay, M. Leuenberger and M. Kanevski (2015).
\href{https://www.elen.ucl.ac.be/Proceedings/esann/esannpdf/es2015-41.pdf}{Morisita-based feature selection for regression problems}.
Proceedings of the 23rd European Symposium on Artificial Neural Networks, Computational Intelligence and
Machine Learning (ESANN), Bruges (Belgium).
}
\author{
Jean Golay \email{Jean.Golay@unil.ch}
}
