% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{pred_intervals}
\alias{pred_intervals}
\title{Produce Error Bounds for Predictions}
\usage{
pred_intervals(
  predictions,
  pred_model,
  gen_model,
  training_matrix,
  gene_lengths,
  biomarker_values,
  alpha = 0.1,
  range_factor = 1.1,
  s = NULL,
  max_panel_length = NULL,
  biomarker = "TMB",
  marker_mut_types = c("NS", "I"),
  model = "Refitted T"
)
}
\arguments{
\item{predictions}{(list)
A predictions object, as produced by get_predictions().}

\item{pred_model}{(list)
A predictive model, as produced by pred_first_fit(), pred_refit_panel() or
pred_refit_range().}

\item{gen_model}{(list)
A generative model, as produce by fit_gen_model}

\item{training_matrix}{(sparse matrix)
A training matrix, as produced by get_tables()$matrix or get_table_from_maf()$matrix.}

\item{gene_lengths}{(data frame)
A data frame with columns 'Hugo_Symbol' and 'max_cds'. See example_maf_data$gene_lengths, or
ensembl_gene_lengths for examples.}

\item{biomarker_values}{(data frame)
A data frame containing the true values of the biomarker in question.}

\item{alpha}{(numeric)
Confidence level for error bounds.}

\item{range_factor}{(numeric)
Value specifying how far beyond the range of max(biomarker) to plot confidence region.}

\item{s}{(numeric)
If input predictions are for a range of panels, s chooses which panel
(column in a pred_fit object) to produce predictions for.}

\item{max_panel_length}{(numeric)
Select panel by maximum length.}

\item{biomarker}{(character)
Which biomarker is being predicted.}

\item{marker_mut_types}{(character)
If biomarker is not one of "TMB" or "TIB", then this is required to specify which mutation type
groups constitute the biomarker.}

\item{model}{(character)
The model (must be based on a linear estimator) for which prediction intervals are being generated.}
}
\value{
A list with two entries:
\itemize{
\item prediction_intervals:
\item confidence_region:
}
}
\description{
A function to produce a confidence region for a linear predictor. In upcoming versions will (hopefully) be greatly simplified.
}
\examples{
example_intervals <- pred_intervals(predictions = get_predictions(example_refit_range,
               new_data = example_tables$val),
               pred_model = example_refit_range, biomarker_values = example_tmb_tables$val,
               gen_model = example_gen_model, training_matrix = example_tables$train$matrix,
               max_panel_length = 15000, gene_lengths = example_maf_data$gene_lengths)

example_confidence_plot <- ggplot2::ggplot() +
  ggplot2::geom_point(data = example_intervals$prediction_intervals,
             ggplot2::aes(x = true_value, y = estimated_value)) +
        ggplot2::geom_ribbon(data = example_intervals$confidence_region,
          ggplot2::aes(x = x, ymin = y_lower, ymax = y_upper),
                    fill = "red", alpha = 0.2) +
        ggplot2::geom_line(data = example_intervals$confidence_region,
          ggplot2::aes(x = x, y = y), linetype = 2) +
        ggplot2::scale_x_log10() + ggplot2::scale_y_log10()

plot(example_confidence_plot)
}
