% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_michaelis}
\alias{FIM_michaelis}
\title{Fisher information matrix for the Michaelis-Menten model.}
\usage{
FIM_michaelis(x, w, param)
}
\arguments{
\item{x}{vector of design points.}

\item{w}{vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.}

\item{param}{vector of model parameters \eqn{\bold{\theta} = (a, b)}.}
}
\value{
Fisher information matrix.
}
\description{
The mean of the response variable is
 \deqn{f(x, \bold{\theta}) = \frac{ax}{(b + x)},}{f(x, \bold{\theta}) = ax/(b + x),}
 where \eqn{\bold{\theta} = (a, b)}.
}
\details{
There is an analytical solution for the locally D-optimal design. See Rasch (1990).
}
\references{
Rasch, D. (1990). Optimum experimental design in nonlinear regression. Communications in Statistics-Theory and Methods, 19(12), 4786-4806.
}
\seealso{
Other FIM: \code{\link{FIM_comp_inhibition}},
  \code{\link{FIM_emax_3par}}, \code{\link{FIM_exp_2par}},
  \code{\link{FIM_exp_3par}},
  \code{\link{FIM_logisitic_1par}},
  \code{\link{FIM_logistic_4par}},
  \code{\link{FIM_logistic}}, \code{\link{FIM_loglin}},
  \code{\link{FIM_mixed_inhibition}},
  \code{\link{FIM_noncomp_inhibition}},
  \code{\link{FIM_power_logistic}},
  \code{\link{FIM_uncomp_inhibition}}
}

