% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibr_chart.R
\name{ibr_chart}
\alias{ibr_chart}
\title{IBR Radarchart}
\usage{
ibr_chart(
  df,
  axistype,
  pcol,
  pfcol,
  plwd,
  plty,
  cglcol,
  cglty,
  axislabcol,
  cglwd,
  caxislabels,
  seg,
  legend = NULL,
  ...
)
}
\arguments{
\item{df}{A data.frame that resulted from the function ibr_std}

\item{axistype}{The type of axes, specified by any of 0:5.  0 means no axis label.  1 means center axis label only.  2 means around-the-chart label only.  3 means both center and around-the-chart (peripheral) labels.  4 is *.** format of 1, 5 is *.** format of 3.  Default is 0.}

\item{pcol}{A vector of color codes for plot data: Default 1:8, which are repeatedly used.}

\item{pfcol}{A vector of color codes for filling polygons: Default NA, which is repeatedly usd.}

\item{plwd}{A vector of line widths for plot data: Default 1, which is repeatedly used.}

\item{plty}{A vector of line types for plot data: Default 1:6, which are repeatedly used.}

\item{cglcol}{Line color for radar grids: Default "navy"}

\item{cglty}{Line type for radar grids: Default 3, which means dotted line.}

\item{axislabcol}{Color of axis label and numbers: Default "blue"}

\item{cglwd}{Line width for radar grids: Default 1, which means thinnest line.}

\item{caxislabels}{Character vector for center axis labels, overwriting values specified in axistype option.  If NULL, the values specified by axistype option are used. Default is NULL.}

\item{seg}{The number of segments for each axis (default 4).}

\item{legend}{Default is NULL, when any other value is given the legend will not appear and you can manually create your own using the legend() function right after building your radarchart}

\item{...}{Miscellaneous arguments to be given for plot.default().}
}
\value{
Returns a radarchart with the standardized values of biomarkers
}
\description{
Plots the IBR standardized values for the enzymes to be compared with one another.
}
\section{Tips}{


If you have any problems with the axis labels, you can do it manually by changing two params in the function: seg and caxislabel.
The caxislabel param has to be a sequence, such as: caxislabels = seq(-1,1.9,0.34), each number is: seq(minvalue, maxvalue, breakvalue)

The seg param can be any number starting from 3, you can change it with: seg = 6.

If you still can't solve the problem, try rounding your standardized values with the function round()
}

\section{References}{


Beliaeff, B., & Burgeot, T. (2002). Integrated biomarker response: A useful tool for ecological risk assessment. Environmental Toxicology and Chemistry, 21(6), 1316–1322.

Devin, S., Burgeot, T., Giambérini, L., Minguez, L., & Pain-Devin, S. (2014). The integrated biomarker response revisited: Optimization to avoid misuse. Environmental Science and Pollution Research, 21(4), 2448–2454. https://doi.org/10.1007/s11356-013-2169-9

Minato Nakazawa (2022). fmsb: Functions for Medical Statistics Book with some Demographic Data. R package version 0.7.0. https://CRAN.R-project.org/package=fmsb
}

\examples{

data(enzact)

ibr_std(enzact) -> enzact_chart

ibr_chart(enzact_chart, legend = FALSE)

colorvector<- c(rgb(1,0.4,0.8,0.7), rgb(0,0.6,0.6,0.7) , rgb(0.4,0.4,0.6,0.7), rgb(0,0.4,0.4,0.7))

legend(x=1.2, y=-0.3, enzact_chart$group, bty = "n", pch=20, col=colorvector, cex=0.9, pt.cex=2)

}
