% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popsim.R
\name{popsim}
\alias{popsim}
\title{Simulation of a model.}
\usage{
popsim(
  model,
  population,
  events_bounds,
  parameters = NULL,
  age_max = Inf,
  time,
  multithreading = FALSE,
  num_threads = NULL,
  clean_step = NULL,
  clean_ratio = 0.1,
  seed = NULL
)
}
\arguments{
\item{model}{Model resulting from a call to the function \code{\link{mk_model}}.}

\item{population}{Data frame representing the initial population.}

\item{events_bounds}{Named vector of events bounds, with names corresponding to events names.}

\item{parameters}{List of model parameters.}

\item{age_max}{Maximum age of individuals in the population (\code{Inf} by default).}

\item{time}{Final time (Numeric). If \code{time} is a vector or vector of simulation discretized times.}

\item{multithreading}{Logical for multithread activation, \code{FALSE} by default. Should be only activated for IBM simulation with no interactions.}

\item{num_threads}{\emph{(Optional)} Number of threads used for multithreading. Set by default to the number of concurrent threads supported by the available hardware implementation.}

\item{clean_step}{\emph{(Optional)} Optional parameter for improving simulation time. Time step for removing dead (or exited) individuals from the population. By default, equal to age_max.}

\item{clean_ratio}{\emph{(Optional)} Optional parameter for improving simulation time. 0.1 by default.}

\item{seed}{\emph{(Optional)} Random generator seed, random by default.}
}
\value{
popsim returns a list of composed of \describe{
\item{arguments}{Simulation inputs (initial population, parameters value, multithreading...)}
\item{logs}{Simulation logs (algorithm duration, accepted/rejected events...).}
\item{population}{If \code{time} is of length 1, population is a data frame composed of all individuals who lived in the population of \code{[0,time]}. If \code{time} is a vector, \code{population} is a list of population data frames.}
}
}
\description{
This function simulates the random evolution of an IBM.
}
\examples{
\donttest{
init_size <- 100000
pop <- data.frame(birth = rep(0, init_size), death = NA)

birth = mk_event_poisson(type = 'birth', intensity = 'lambda')
death = mk_event_poisson(type = 'death', intensity = 'mu')
params = list('lambda' = 100, 'mu' = 100)
birth_death <- mk_model(events = list(birth, death),
                       parameters = params)

sim_out <- popsim(model = birth_death,
                 population = pop,
                 events_bounds = c('birth' = params$lambda, 'death' = params$mu),
                 parameters = params,
                 time = 10)
                       }
}
\seealso{
\code{\link{mk_model}}.
}
