% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{Tph}
\alias{Tph}
\title{Temperature, Function of Pressure and Enthalpy}
\usage{
Tph(p, h)
}
\arguments{
\item{p}{Pressure [ MPa ]}

\item{h}{Enthalpy [ kJ kg-1 ]}
}
\value{
The Temperature: T [ K ] and an Error Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{Tph(p,h)} returns the water temperature, T [ K ],
     for given p [MPa] and h [ kJ k-1 ].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
p <- 10.0003858
h <- 977.181624
Tph(p,h)

}

