% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bessel.R
\name{BesselA}
\alias{BesselA}
\title{Type one Bessel function of Herz}
\usage{
BesselA(m, x, nu)
}
\arguments{
\item{m}{truncation weight of the summation, a positive integer}

\item{x}{either a real or complex square matrix,
or a numeric or complex vector, the eigenvalues of the matrix}

\item{nu}{the order parameter, real or complex number with \code{Re(nu)>-1}}
}
\value{
A real or complex number.
}
\description{
Evaluates the type one Bessel function of Herz.
}
\note{
This function is usually defined
  for a symmetric real matrix or a Hermitian complex matrix.
}
\examples{
# for a scalar x, the relation with the Bessel J-function:
t <- 2
nu <- 3
besselJ(t, nu)
BesselA(m=15, t^2/4, nu) * (t/2)^nu
# it also holds for a complex variable:
t <- 1 + 2i
Bessel::BesselJ(t, nu)
BesselA(m=15, t^2/4, nu) * (t/2)^nu
}
\references{
A. K. Gupta and D. K. Nagar.
\emph{Matrix variate distributions}. Chapman and Hall, 1999.
}
