% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_ROUGH.R
\name{GetEstimate_ROUGH}
\alias{GetEstimate_ROUGH}
\title{Rough estimate of a distribution}
\usage{
GetEstimate_ROUGH(y, dist)
}
\arguments{
\item{y}{numeric vector, data}

\item{dist}{character, distribution name}
}
\value{
A list with the following components:
    \item{par}{numeric vector, estimated parameter vector.}
    \item{obj}{numeric, objective fonction (NA for this estimate)}
    \item{ok}{logical, did computation succeed?}
    \item{err}{integer, error code (0 if ok)}
    \item{message}{error message}
}
\description{
Returns a rough first-guess estimate of a distribution.
This estimate may be poor but it solely aims at being used as a starting point 
for more advanced estimation approaches (e.g. max-likelihood or Bayesian).
It is therefore chosen as an easy-to-compute explicit formula, robust and error-proof.
}
\examples{
y=c(9.2,9.5,11.4,9.5,9.4,9.6,10.5,11.1,10.5,10.4)
GetEstimate_ROUGH(y,'Normal')
GetEstimate_ROUGH(y,'LogNormal')
GetEstimate_ROUGH(y,'Gumbel')
GetEstimate_ROUGH(y,'GEV')
GetEstimate_ROUGH(y,'Poisson')
}
