% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{GOF_nash_sutcliffe_efficiency}
\alias{GOF_nash_sutcliffe_efficiency}
\title{Calculate Nash--Sutcliffe Efficiency (NSE)}
\usage{
GOF_nash_sutcliffe_efficiency(mod, obs, j = 2, na.rm = TRUE)
}
\arguments{
\item{mod}{'numeric' vector. Modeled or simulated values. Must be same length as \code{obs}.}

\item{obs}{'numeric' vector. Observed or comparison values. Must be same length as \code{mod}.}

\item{j}{'numeric' value. Exponent value for modified NSE (mNSE) equation. Default value is
\code{j = 2}, which is traditional NSE equation.}

\item{na.rm}{'boolean' \code{TRUE} or \code{FALSE}. Should \code{NA} values be removed before computing. If any
\code{NA} values are present in \code{mod} or \code{obs}, the \emph{i}th position from each will be removed before
calculating. If \code{NA} values are present and \code{na.rm = FALSE}, then function will return \code{NA}.
Default is \code{TRUE}.}
}
\value{
Value of computed NSE or mNSE.
}
\description{
Calculate Nash--Sutcliffe Efficiency (NSE) (with options for modified NSE) between
modeled (simulated) and observed values.
}
\examples{
GOF_nash_sutcliffe_efficiency(
  mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs
)

}
\references{
Krause, P., Boyle, D.P., and Base, F., 2005. Comparison of different efficiency criteria for
hydrological model assessment: Advances in Geosciences, v. 5, p. 89-97.\cr
[Also available at https://doi.org/10.5194/adgeo-5-89-2005.]

Legates D.R and McCabe G.J., 1999, Evaluating the use of "goodness-of-fit" measures in hydrologic
and hydroclimatic model validation: Water Resources Research. v. 35, no. 1, p. 233-241.
[Also available at https://doi.org/10.1029/1998WR900018.]

Nash, J.E. and Sutcliffe, J.V., 1970, River flow forecasting through conceptual models part I:
A discussion of principles: Journal of Hydrology, v. 10, no. 3, p. 282-290.
[Also available at https://doi.org/10.1016/0022-1694(70)90255-6.]
}
\keyword{goodness-of-fit}
