% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.quantiles.R
\name{as.quantiles}
\alias{as.quantiles}
\title{Extract quantile distribution from mcmcComposite object}
\usage{
as.quantiles(x, chain = 1, fun = function(...)
  return(as.numeric(list(...))), probs = c(0.025, 0.975), xlim = NULL,
  nameparxlim = NULL, namepar = NULL)
}
\arguments{
\item{x}{A mcmcComposite obtained as a result of \code{MHalgoGen()} function}

\item{chain}{The number of the chain in which to get parameters}

\item{fun}{The function to apply the parameters}

\item{probs}{The probability to get quantiles}

\item{xlim}{The values to apply in fun}

\item{nameparxlim}{The name of the parameter for xlim}

\item{namepar}{The name of parameters from mcmc object to be used in fun}
}
\value{
A data.frame with quantiles
}
\description{
Extract quantile distribution from mcmcComposite object
}
\examples{
\dontrun{
library(HelpersMG)
require(coda)
x <- rnorm(30, 10, 2)
dnormx <- function(data, x) {
 data <- unlist(data)
 return(-sum(dnorm(data, mean=x['mean'], sd=x['sd'], log=TRUE)))
}
parameters_mcmc <- data.frame(Density=c('dnorm', 'dlnorm'), 
Prior1=c(10, 0.5), Prior2=c(2, 0.5), SDProp=c(1, 1), 
Min=c(-3, 0), Max=c(100, 10), Init=c(10, 2), stringsAsFactors = FALSE, 
row.names=c('mean', 'sd'))
mcmc_run <- MHalgoGen(n.iter=10000, parameters=parameters_mcmc, data=x, 
likelihood=dnormx, n.chains=1, n.adapt=100, thin=1, trace=1)
k <- as.quantiles(x=mcmc_run, namepar="mean")
k <- as.quantiles(x=mcmc_run, namepar="mean", 
                 xlim=c(1:5), nameparxlim="sd", 
                 fun=function(...) return(sum(as.numeric(list(...)))))
}
}
\seealso{
Other mcmcComposite functions: \code{\link{MHalgoGen}},
  \code{\link{as.mcmc.mcmcComposite}},
  \code{\link{as.parameters}},
  \code{\link{merge.mcmcComposite}},
  \code{\link{plot.mcmcComposite}},
  \code{\link{summary.mcmcComposite}}
}
\author{
Marc Girondot
}
\concept{mcmcComposite functions}
