% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_export.R
\name{WriteTimeOutput}
\alias{WriteTimeOutput}
\title{Write a 'timeXXXX.txt' file}
\usage{
WriteTimeOutput(x, filename, dt.format = "\%Y-\%m-\%d")
}
\arguments{
\item{x}{The object to be written, a dataframe with \code{comment} and \code{subid} attributes, as an object returned from
\code{\link{ReadTimeOutput}}.}

\item{filename}{A character string naming a file to write to. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{dt.format}{Date-time \code{format} string as in \code{\link{strptime}}. Incomplete format strings for monthly
and annual values allowed, e.g. '\\\%Y'.}
}
\value{
No return value, called for export to text files.
}
\description{
Function to export a time output file from R.
}
\details{
\code{WriteTimeOutput} exports a data frame with headers and formatting options adjusted to match HYPE's time output files.
}
\examples{
te <- ReadTimeOutput(filename = system.file("demo_model", "results", "timeCOUT.txt", 
                     package = "HYPEtools"), dt.format = "\%Y-\%m")
WriteTimeOutput(x = te, filename = tempfile(), dt.format = "\%Y-\%m")

}
