% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_function.R
\name{summarize_pc_name}
\alias{summarize_pc_name}
\title{Summarize the features (e.g. genes) that contribute to the test result, i.e. those features consistently show up in the sparse principle components.}
\usage{
summarize_pc_name(
  testing_result,
  latent_fator_index = 1,
  method = "majority voting"
)
}
\arguments{
\item{testing_result}{The output/test result list from simple_pc_testing() or debiased_pc_testing().}

\item{latent_fator_index}{Which principle component should the algorithm summarize? Default is PC1.}

\item{method}{How to combine the feature list across different splits. Default is 'majority voting'---features that show up more than 50\% of the splits are considered active/useful. It can be 'union'---all the features pooled together; or 'intersection'---only include features showing up in all splits.}
}
\value{
A list of names of features (your very original input data need to have column names!) that contribute to the test result.

Feature names that consistently showing up in the estimated PC vectors.
}
\description{
Summarize the features (e.g. genes) that contribute to the test result, i.e. those features consistently show up in the sparse principle components.
}
