% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDShOP-package.R
\docType{package}
\name{HDShOP-package}
\alias{HDShOP-package}
\title{A set of tools for shrinkage estimation of mean-variance optimal portfolios}
\description{
Package HDShOP has the following three important functions: \code{\link{MVShrinkPortfolio}},
\code{\link{CovarEstim}} and \code{\link{MeanEstim}}. MVShrinkPortfolio creates mean-variance
portfolios using shrinkage estimation methods for portfolio weights. CovarEstim computes several estimators
of the covariance matrix, while MeanEstim computes several estimators of the mean vector. Each of these three functions is
supplied a name of the method used to perform the estimation. All portfolios are stored in objects of
class MeanVar_portfolio and some have a subclass, specific to their kind, that inherits from
MeanVar_portfolio. For the latter class constructor, validator and helper functions are available, so
that custom mean-variance portfolios may be coded by users.
}
\section{Methods}{


MeanEstim: \insertCite{BOP2019}{HDShOP}, James-Stein and Bayes-Stein estimators \insertCite{Jorion1986}{HDShOP}.

CovarEstim: \insertCite{BGP2014}{HDShOP}, \insertCite{LW2020}{HDShOP}.

MVShrinkPortfolio: \insertCite{BDOPS2021}{HDShOP}, \insertCite{BDPS2019}{HDShOP}.
}

\references{
\insertAllCited{}
}
