\name{grid.AcgtExecuteScript}
\alias{grid.AcgtExecuteScript}
\title{grid.AcgtExecuteScript}
\description{
  executes a specified ACGT workflow and returns the name and the id of a result file in the DMS
  
}
\usage{
grid.AcgtExecuteScript(rCode, inputIDs, outputNames)
}
\arguments{
  \item{rCode}{the rCode to execute. be careful, each \texttt{"} needs 3 backslashes in front and the total string must be surrounded by \texttt{\"} }
  \item{inputIDs}{all inputIDs needed by the script as a vector}
  \item{outputNames}{all outputNames generated by the script as a vector}  
  }

\details{
!!!Only for members of the ACGT Project with a valid MyProxy Credential!!!
ACGTLIBPATH must point to a folder with the GridR-ACGTLibs
To execute this function myProxyUsername and myProxyPwd must be set.
}

\examples{

##path to ACGT Libraries (ACGTLIBPATH) is needed to run the following:
#library("GridR")
#grid.init(service="local")
#grid.AcgtExecuteScript("\"cat(\\\"1\\\")\"", 1618, "test.out")
}
\author{ Malte Lohmeyer }
\seealso{
\code{\link{grid.AcgtListRepo}}
\code{\link{grid.AcgtUpload}}
\code{\link{grid.AcgtDownload}}
}
\keyword{ programming }