% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_format_info.R
\name{get_format_info}
\alias{get_format_info}
\title{Get Format Information from Goodreads}
\usage{
get_format_info(file_path)
}
\arguments{
\item{file_path}{A character string specifying the path to the file containing Goodreads book IDs.}
}
\value{
A named list where each element contains the format information for a book.
}
\description{
This function takes a file path containing Goodreads book IDs and retrieves
the format information for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the function
format_info <- get_format_info(temp_file)
print(format_info)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
