% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_analysis.R
\name{analyze_sentiment}
\alias{analyze_sentiment}
\title{Perform sentiment analysis on book reviews with negation handling}
\usage{
analyze_sentiment(reviews_df, lexicon = "afinn")
}
\arguments{
\item{reviews_df}{A data frame containing the output from scrape_reviews.}

\item{lexicon}{The sentiment lexicon to use. Options are "afinn", "bing", or "nrc".}
}
\value{
A data frame with sentiment scores for each review.
}
\description{
This function takes the output from scrape_reviews and performs sentiment analysis,
including basic negation scope detection.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the scrape_reviews function
reviews <- scrape_reviews(temp_file, num_reviews = 5, use_parallel = FALSE)

# Check if reviews were successfully scraped
if (nrow(reviews) > 0) {
  # Perform sentiment analysis
  sentiment_results <- analyze_sentiment(reviews, lexicon = "afinn")

  # Display the first few rows of the results
  print(head(sentiment_results))
} else {
  cat("No reviews found. Cannot perform sentiment analysis.\n")
}

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
