% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdfpd_get_info_companies.R
\name{gdfpd.get.info.companies}
\alias{gdfpd.get.info.companies}
\title{Reads up to date information about Bovespa companies from a github file}
\usage{
gdfpd.get.info.companies(type.data = "companies_files",
  cache.folder = "DFP Cache Folder")
}
\arguments{
\item{type.data}{A string that sets the type of information to be returned ('companies' or 'companies_files').
If 'companies', it will return a dataframe with several information about companies, but without download links.}

\item{cache.folder}{Folder to cache (save) all processed information. Default = file.path(getwd(),'DFP Cache Folder')}
}
\value{
A dataframe with several information about Bovespa companies
}
\description{
A csv file with information about available companies, file links and time periods is read from github.
This file is manually updated by the author. When run for the first time in a R session, a .RDATA file
containing the output of the function is saved for caching.
}
\examples{

\dontrun{ # keep cran check fast
df.info <- gdfpd.get.info.companies()
str(df.info)
}
}
