% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ger_indices.R
\name{ger_MGT}
\alias{ger_MGT}
\title{Mean Germination Time}
\usage{
ger_MGT(evalName, data)
}
\arguments{
\item{evalName}{Prefix of the names of the periods of evaluation.}

\item{data}{The name of the data frame containing the data.}
}
\value{
It returns an vector with the values of Mean Germination Time.
}
\description{
This function calculates the mean germination time of germination according at the time lapse of the evaluations.
}
\details{
It was proposed by Haberlandt in 1875. It is calculated as the weighted average germination time. 
The number of germinated seeds at the intervals established for the collection of data is used as weight. 
It is expressed in terms of the same units of time used in the germination count (CZABATOR, 1962).
}
\examples{

library(GerminaR)
dfr <- prosopis
mgt <- ger_MGT(evalName = "D", data = dfr)
mgt
}
\references{
CZABATOR, F. J. Germination value: an index combining speed and completeness of pine seed germination. 
Forest Science, v. 8, n. 4, p. 386-396, 1962.
}
