% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{exp_map}
\alias{exp_map}
\title{Exponential map}
\usage{
exp_map(manifold, p, v)
}
\arguments{
\item{manifold}{Type of manifold (\code{'euclidean'}, \code{'sphere'}, or
\code{'kendall'}).}

\item{p}{A vector (or column matrix) representing a point on the manifold.}

\item{v}{A vector (or column matrix) tangent to \code{p}.}
}
\value{
A vector representing a point on the manifold.
}
\description{
Performs the exponential map \eqn{\textrm{Exp}_p(v)} on the given manifold.
}
\examples{
exp_map('sphere', c(1, 0, 0, 0, 0), c(0, 0, pi / 4, 0, 0))

}
\references{
Fletcher, P. T. (2013). Geodesic regression and the theory of
  least squares on Riemannian manifolds. International Journal of Computer
  Vision, 105, 171-185.

  Cornea, E., Zhu, H., Kim, P. and Ibrahim, J. G. (2017). Regression models
  on Riemannian symmetric spaces. Journal of the Royal Statistical Society:
  Series B, 79, 463-482.

  Shin, H.-Y. and Oh H.-S. (2020). Robust Geodesic Regression. <arXiv:2007.04518>
}
\seealso{
\code{\link{log_map}}.
}
\author{
Ha-Young Shin
}
